/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.soap;

import com.sun.xml.internal.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ParseException;
import com.sun.xml.internal.messaging.saaj.soap.MessageImpl;
import com.sun.xml.internal.messaging.saaj.soap.ver1_1.Message1_1Impl;
import com.sun.xml.internal.messaging.saaj.soap.ver1_2.Message1_2Impl;
import com.sun.xml.internal.messaging.saaj.util.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class MessageFactoryImpl
extends MessageFactory {
    protected static final Logger log = Logger.getLogger("com.sun.xml.internal.messaging.saaj.soap", "com.sun.xml.internal.messaging.saaj.soap.LocalStrings");
    protected OutputStream listener;
    protected boolean lazyAttachments = false;

    public OutputStream listen(OutputStream outputStream) {
        OutputStream outputStream2 = this.listener;
        this.listener = outputStream;
        return outputStream2;
    }

    @Override
    public SOAPMessage createMessage() throws SOAPException {
        throw new UnsupportedOperationException();
    }

    public SOAPMessage createMessage(boolean bl, boolean bl2) throws SOAPException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream inputStream) throws SOAPException, IOException {
        String string = MessageImpl.getContentType(mimeHeaders);
        if (this.listener != null) {
            inputStream = new TeeInputStream(inputStream, this.listener);
        }
        try {
            ContentType contentType = new ContentType(string);
            int n = MessageImpl.identifyContentType(contentType);
            if (MessageImpl.isSoap1_1Content(n)) {
                return new Message1_1Impl(mimeHeaders, contentType, n, inputStream);
            }
            if (MessageImpl.isSoap1_2Content(n)) {
                return new Message1_2Impl(mimeHeaders, contentType, n, inputStream);
            }
            log.severe("SAAJ0530.soap.unknown.Content-Type");
            throw new SOAPExceptionImpl("Unrecognized Content-Type");
        }
        catch (ParseException parseException) {
            log.severe("SAAJ0531.soap.cannot.parse.Content-Type");
            throw new SOAPExceptionImpl("Unable to parse content type: " + parseException.getMessage());
        }
    }

    protected static final String getContentType(MimeHeaders mimeHeaders) {
        String[] stringArray = mimeHeaders.getHeader("Content-Type");
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    public void setLazyAttachmentOptimization(boolean bl) {
        this.lazyAttachments = bl;
    }
}

