/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.bind.DatatypeConverterImpl;
import com.sun.xml.internal.org.jvnet.staxex.Base64Data;
import com.sun.xml.internal.org.jvnet.staxex.NamespaceContextEx;
import com.sun.xml.internal.org.jvnet.staxex.XMLStreamReaderEx;
import com.sun.xml.internal.org.jvnet.staxex.XMLStreamWriterEx;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSFeatureList;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.api.pipe.StreamSOAPCodec;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.internal.ws.developer.SerializationFeature;
import com.sun.xml.internal.ws.developer.StreamingDataHandler;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.HasEncoding;
import com.sun.xml.internal.ws.encoding.MimeCodec;
import com.sun.xml.internal.ws.encoding.MimeMultipartParser;
import com.sun.xml.internal.ws.message.MimeAttachmentSet;
import com.sun.xml.internal.ws.server.UnsupportedMediaException;
import com.sun.xml.internal.ws.streaming.MtomStreamWriter;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.streaming.XMLStreamWriterUtil;
import com.sun.xml.internal.ws.util.ByteArrayDataSource;
import com.sun.xml.internal.ws.util.xml.NamespaceContextExAdaper;
import com.sun.xml.internal.ws.util.xml.XMLStreamReaderFilter;
import com.sun.xml.internal.ws.util.xml.XMLStreamWriterFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.MTOMFeature;

public class MtomCodec
extends MimeCodec {
    public static final String XOP_XML_MIME_TYPE = "application/xop+xml";
    public static final String XOP_LOCALNAME = "Include";
    public static final String XOP_NAMESPACEURI = "http://www.w3.org/2004/08/xop/include";
    private final StreamSOAPCodec codec;
    private final MTOMFeature mtomFeature;
    private final SerializationFeature sf;
    private static final String DECODED_MESSAGE_CHARSET = "decodedMessageCharset";

    MtomCodec(SOAPVersion sOAPVersion, StreamSOAPCodec streamSOAPCodec, WSFeatureList wSFeatureList) {
        super(sOAPVersion, wSFeatureList);
        this.codec = streamSOAPCodec;
        this.sf = wSFeatureList.get(SerializationFeature.class);
        MTOMFeature mTOMFeature = wSFeatureList.get(MTOMFeature.class);
        this.mtomFeature = mTOMFeature == null ? new MTOMFeature() : mTOMFeature;
    }

    @Override
    public ContentType getStaticContentType(Packet packet) {
        return MtomCodec.getStaticContentTypeStatic(packet, this.version);
    }

    public static ContentType getStaticContentTypeStatic(Packet packet, SOAPVersion sOAPVersion) {
        ContentType contentType = (ContentType)packet.getInternalContentType();
        if (contentType != null) {
            return contentType;
        }
        String string = UUID.randomUUID().toString();
        String string2 = "uuid:" + string;
        String string3 = "<rootpart*" + string + "@example.jaxws.sun.com>";
        String string4 = SOAPVersion.SOAP_11.equals((Object)sOAPVersion) ? null : MtomCodec.createActionParameter(packet);
        String string5 = "boundary=\"" + string2 + "\"";
        String string6 = "multipart/related;start=\"" + string3 + "\";type=\"" + XOP_XML_MIME_TYPE + "\";" + string5 + ";start-info=\"" + sOAPVersion.contentType + (string4 == null ? "" : string4) + "\"";
        ContentTypeImpl contentTypeImpl = SOAPVersion.SOAP_11.equals((Object)sOAPVersion) ? new ContentTypeImpl(string6, packet.soapAction == null ? "" : packet.soapAction, null) : new ContentTypeImpl(string6, null, null);
        contentTypeImpl.setBoundary(string2);
        contentTypeImpl.setRootId(string3);
        packet.setContentType(contentTypeImpl);
        return contentTypeImpl;
    }

    private static String createActionParameter(Packet packet) {
        return packet.soapAction != null ? ";action=\\\"" + packet.soapAction + "\\\"" : "";
    }

    @Override
    public ContentType encode(Packet packet, OutputStream outputStream) throws IOException {
        ContentTypeImpl contentTypeImpl = (ContentTypeImpl)this.getStaticContentType(packet);
        String string = contentTypeImpl.getBoundary();
        String string2 = contentTypeImpl.getRootId();
        if (packet.getMessage() != null) {
            try {
                String string3 = this.getPacketEncoding(packet);
                packet.invocationProperties.remove(DECODED_MESSAGE_CHARSET);
                String string4 = MtomCodec.getActionParameter(packet, this.version);
                String string5 = MtomCodec.getSOAPXopContentType(string3, this.version, string4);
                MtomCodec.writeln("--" + string, outputStream);
                MtomCodec.writeMimeHeaders(string5, string2, outputStream);
                ArrayList<ByteArrayBuffer> arrayList = new ArrayList<ByteArrayBuffer>();
                MtomStreamWriterImpl mtomStreamWriterImpl = new MtomStreamWriterImpl(XMLStreamWriterFactory.create(outputStream, string3), arrayList, string, this.mtomFeature);
                packet.getMessage().writeTo(mtomStreamWriterImpl);
                XMLStreamWriterFactory.recycle(mtomStreamWriterImpl);
                MtomCodec.writeln(outputStream);
                for (ByteArrayBuffer byteArrayBuffer : arrayList) {
                    byteArrayBuffer.write(outputStream);
                }
                this.writeNonMtomAttachments(packet.getMessage().getAttachments(), outputStream, string);
                MtomCodec.writeAsAscii("--" + string, outputStream);
                MtomCodec.writeAsAscii("--", outputStream);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(xMLStreamException);
            }
        }
        return contentTypeImpl;
    }

    public static String getSOAPXopContentType(String string, SOAPVersion sOAPVersion, String string2) {
        return "application/xop+xml;charset=" + string + ";type=\"" + sOAPVersion.contentType + string2 + "\"";
    }

    public static String getActionParameter(Packet packet, SOAPVersion sOAPVersion) {
        return sOAPVersion == SOAPVersion.SOAP_11 ? "" : MtomCodec.createActionParameter(packet);
    }

    public static void writeMimeHeaders(String string, String string2, OutputStream outputStream) throws IOException {
        String string3 = string2;
        if (string3 != null && string3.length() > 0 && string3.charAt(0) != '<') {
            string3 = '<' + string3 + '>';
        }
        MtomCodec.writeln("Content-Id: " + string3, outputStream);
        MtomCodec.writeln("Content-Type: " + string, outputStream);
        MtomCodec.writeln("Content-Transfer-Encoding: binary", outputStream);
        MtomCodec.writeln(outputStream);
    }

    private void writeNonMtomAttachments(AttachmentSet attachmentSet, OutputStream outputStream, String string) throws IOException {
        for (Attachment attachment : attachmentSet) {
            StreamingDataHandler streamingDataHandler;
            DataHandler dataHandler = attachment.asDataHandler();
            if (dataHandler instanceof StreamingDataHandler && (streamingDataHandler = (StreamingDataHandler)dataHandler).getHrefCid() != null) continue;
            MtomCodec.writeln("--" + string, outputStream);
            MtomCodec.writeMimeHeaders(attachment.getContentType(), attachment.getContentId(), outputStream);
            attachment.writeTo(outputStream);
            MtomCodec.writeln(outputStream);
        }
    }

    @Override
    public ContentType encode(Packet packet, WritableByteChannel writableByteChannel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MtomCodec copy() {
        return new MtomCodec(this.version, (StreamSOAPCodec)this.codec.copy(), this.features);
    }

    private static String encodeCid() {
        String string = "example.jaxws.sun.com";
        String string2 = UUID.randomUUID() + "@";
        return string2 + string;
    }

    @Override
    protected void decode(MimeMultipartParser mimeMultipartParser, Packet packet) throws IOException {
        String string = null;
        String string2 = mimeMultipartParser.getRootPart().getContentType();
        if (string2 != null) {
            string = new ContentTypeImpl(string2).getCharSet();
        }
        if (string != null && !Charset.isSupported(string)) {
            throw new UnsupportedMediaException(string);
        }
        if (string != null) {
            packet.invocationProperties.put(DECODED_MESSAGE_CHARSET, string);
        } else {
            packet.invocationProperties.remove(DECODED_MESSAGE_CHARSET);
        }
        MtomXMLStreamReaderEx mtomXMLStreamReaderEx = new MtomXMLStreamReaderEx(mimeMultipartParser, XMLStreamReaderFactory.create(null, mimeMultipartParser.getRootPart().asInputStream(), string, true));
        packet.setMessage(this.codec.decode(mtomXMLStreamReaderEx, new MimeAttachmentSet(mimeMultipartParser)));
        packet.setMtomFeature(this.mtomFeature);
        packet.setContentType(mimeMultipartParser.getContentType());
    }

    private String getPacketEncoding(Packet packet) {
        if (this.sf != null && this.sf.getEncoding() != null) {
            return this.sf.getEncoding().equals("") ? "utf-8" : this.sf.getEncoding();
        }
        return MtomCodec.determinePacketEncoding(packet);
    }

    public static String determinePacketEncoding(Packet packet) {
        if (packet != null && packet.endpoint != null) {
            String string = (String)packet.invocationProperties.get(DECODED_MESSAGE_CHARSET);
            return string == null ? "utf-8" : string;
        }
        return "utf-8";
    }

    public static class ByteArrayBuffer {
        final String contentId;
        private final DataHandler dh;
        private final String boundary;

        ByteArrayBuffer(@NotNull DataHandler dataHandler, String string) {
            StreamingDataHandler streamingDataHandler;
            this.dh = dataHandler;
            String string2 = null;
            if (dataHandler instanceof StreamingDataHandler && (streamingDataHandler = (StreamingDataHandler)dataHandler).getHrefCid() != null) {
                string2 = streamingDataHandler.getHrefCid();
            }
            this.contentId = string2 != null ? string2 : MtomCodec.encodeCid();
            this.boundary = string;
        }

        public void write(OutputStream outputStream) throws IOException {
            MimeCodec.writeln("--" + this.boundary, outputStream);
            MtomCodec.writeMimeHeaders(this.dh.getContentType(), this.contentId, outputStream);
            this.dh.writeTo(outputStream);
            MimeCodec.writeln(outputStream);
        }
    }

    public static class MtomStreamWriterImpl
    extends XMLStreamWriterFilter
    implements XMLStreamWriterEx,
    MtomStreamWriter,
    HasEncoding {
        private final List<ByteArrayBuffer> mtomAttachments;
        private final String boundary;
        private final MTOMFeature myMtomFeature;

        public MtomStreamWriterImpl(XMLStreamWriter xMLStreamWriter, List<ByteArrayBuffer> list, String string, MTOMFeature mTOMFeature) {
            super(xMLStreamWriter);
            this.mtomAttachments = list;
            this.boundary = string;
            this.myMtomFeature = mTOMFeature;
        }

        @Override
        public void writeBinary(byte[] byArray, int n, int n2, String string) throws XMLStreamException {
            if (this.myMtomFeature.getThreshold() > n2) {
                this.writeCharacters(DatatypeConverterImpl._printBase64Binary(byArray, n, n2));
                return;
            }
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(new DataHandler(new ByteArrayDataSource(byArray, n, n2, string)), this.boundary);
            this.writeBinary(byteArrayBuffer);
        }

        @Override
        public void writeBinary(DataHandler dataHandler) throws XMLStreamException {
            this.writeBinary(new ByteArrayBuffer(dataHandler, this.boundary));
        }

        @Override
        public OutputStream writeBinary(String string) throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writePCDATA(CharSequence charSequence) throws XMLStreamException {
            if (charSequence == null) {
                return;
            }
            if (charSequence instanceof Base64Data) {
                Base64Data base64Data = (Base64Data)charSequence;
                this.writeBinary(base64Data.getDataHandler());
                return;
            }
            this.writeCharacters(charSequence.toString());
        }

        private void writeBinary(ByteArrayBuffer byteArrayBuffer) {
            try {
                this.mtomAttachments.add(byteArrayBuffer);
                String string = this.writer.getPrefix(MtomCodec.XOP_NAMESPACEURI);
                if (string == null || !string.equals("xop")) {
                    this.writer.setPrefix("xop", MtomCodec.XOP_NAMESPACEURI);
                    this.writer.writeNamespace("xop", MtomCodec.XOP_NAMESPACEURI);
                }
                this.writer.writeStartElement(MtomCodec.XOP_NAMESPACEURI, MtomCodec.XOP_LOCALNAME);
                this.writer.writeAttribute("href", "cid:" + byteArrayBuffer.contentId);
                this.writer.writeEndElement();
                this.writer.flush();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(xMLStreamException);
            }
        }

        @Override
        public Object getProperty(String string) throws IllegalArgumentException {
            Object v;
            if (string.equals("sjsxp-outputstream") && this.writer instanceof Map && (v = ((Map)((Object)this.writer)).get("sjsxp-outputstream")) != null) {
                return v;
            }
            return super.getProperty(string);
        }

        @Override
        public AttachmentMarshaller getAttachmentMarshaller() {
            return new AttachmentMarshaller(){

                @Override
                public String addMtomAttachment(DataHandler dataHandler, String string, String string2) {
                    ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(dataHandler, boundary);
                    mtomAttachments.add(byteArrayBuffer);
                    return "cid:" + byteArrayBuffer.contentId;
                }

                @Override
                public String addMtomAttachment(byte[] byArray, int n, int n2, String string, String string2, String string3) {
                    if (myMtomFeature.getThreshold() > n2) {
                        return null;
                    }
                    ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(new DataHandler(new ByteArrayDataSource(byArray, n, n2, string)), boundary);
                    mtomAttachments.add(byteArrayBuffer);
                    return "cid:" + byteArrayBuffer.contentId;
                }

                @Override
                public String addSwaRefAttachment(DataHandler dataHandler) {
                    ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(dataHandler, boundary);
                    mtomAttachments.add(byteArrayBuffer);
                    return "cid:" + byteArrayBuffer.contentId;
                }

                @Override
                public boolean isXOPPackage() {
                    return true;
                }
            };
        }

        public List<ByteArrayBuffer> getMtomAttachments() {
            return this.mtomAttachments;
        }

        @Override
        public String getEncoding() {
            return XMLStreamWriterUtil.getEncoding(this.writer);
        }

        @Override
        public NamespaceContextEx getNamespaceContext() {
            NamespaceContext namespaceContext = this.writer.getNamespaceContext();
            return new MtomNamespaceContextEx(namespaceContext);
        }

        private static class MtomNamespaceContextEx
        implements NamespaceContextEx {
            private final NamespaceContext nsContext;

            public MtomNamespaceContextEx(NamespaceContext namespaceContext) {
                this.nsContext = namespaceContext;
            }

            @Override
            public Iterator<NamespaceContextEx.Binding> iterator() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getNamespaceURI(String string) {
                return this.nsContext.getNamespaceURI(string);
            }

            @Override
            public String getPrefix(String string) {
                return this.nsContext.getPrefix(string);
            }

            @Override
            public Iterator getPrefixes(String string) {
                return this.nsContext.getPrefixes(string);
            }
        }
    }

    public static class MtomXMLStreamReaderEx
    extends XMLStreamReaderFilter
    implements XMLStreamReaderEx {
        private final MimeMultipartParser mimeMP;
        private boolean xopReferencePresent = false;
        private Base64Data base64AttData;
        private char[] base64EncodedText;
        private String xopHref;

        public MtomXMLStreamReaderEx(MimeMultipartParser mimeMultipartParser, XMLStreamReader xMLStreamReader) {
            super(xMLStreamReader);
            this.mimeMP = mimeMultipartParser;
        }

        @Override
        public CharSequence getPCDATA() throws XMLStreamException {
            if (this.xopReferencePresent) {
                return this.base64AttData;
            }
            return this.reader.getText();
        }

        @Override
        public NamespaceContextEx getNamespaceContext() {
            return new NamespaceContextExAdaper(this.reader.getNamespaceContext());
        }

        @Override
        public String getElementTextTrim() throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getTextLength() {
            if (this.xopReferencePresent) {
                return this.base64AttData.length();
            }
            return this.reader.getTextLength();
        }

        @Override
        public int getTextStart() {
            if (this.xopReferencePresent) {
                return 0;
            }
            return this.reader.getTextStart();
        }

        @Override
        public int getEventType() {
            if (this.xopReferencePresent) {
                return 4;
            }
            return super.getEventType();
        }

        @Override
        public int next() throws XMLStreamException {
            int n = this.reader.next();
            if (n == 1 && this.reader.getLocalName().equals(MtomCodec.XOP_LOCALNAME) && this.reader.getNamespaceURI().equals(MtomCodec.XOP_NAMESPACEURI)) {
                String string = this.reader.getAttributeValue(null, "href");
                try {
                    this.xopHref = string;
                    Attachment attachment = this.getAttachment(string);
                    if (attachment != null) {
                        DataHandler dataHandler = attachment.asDataHandler();
                        if (dataHandler instanceof StreamingDataHandler) {
                            ((StreamingDataHandler)dataHandler).setHrefCid(attachment.getContentId());
                        }
                        this.base64AttData = new Base64Data();
                        this.base64AttData.set(dataHandler);
                    }
                    this.xopReferencePresent = true;
                }
                catch (IOException iOException) {
                    throw new WebServiceException(iOException);
                }
                XMLStreamReaderUtil.nextElementContent(this.reader);
                return 4;
            }
            if (this.xopReferencePresent) {
                this.xopReferencePresent = false;
                this.base64EncodedText = null;
                this.xopHref = null;
            }
            return n;
        }

        private String decodeCid(String string) {
            try {
                string = URLDecoder.decode(string, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return string;
        }

        private Attachment getAttachment(String string) throws IOException {
            if (string.startsWith("cid:")) {
                string = string.substring(4, string.length());
            }
            if (string.indexOf(37) != -1) {
                string = this.decodeCid(string);
                return this.mimeMP.getAttachmentPart(string);
            }
            return this.mimeMP.getAttachmentPart(string);
        }

        @Override
        public char[] getTextCharacters() {
            if (this.xopReferencePresent) {
                char[] cArray = new char[this.base64AttData.length()];
                this.base64AttData.writeTo(cArray, 0);
                return cArray;
            }
            return this.reader.getTextCharacters();
        }

        @Override
        public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
            if (this.xopReferencePresent) {
                if (cArray == null) {
                    throw new NullPointerException("target char array can't be null");
                }
                if (n2 < 0 || n3 < 0 || n < 0 || n2 >= cArray.length || n2 + n3 > cArray.length) {
                    throw new IndexOutOfBoundsException();
                }
                int n4 = this.base64AttData.length();
                if (n > n4) {
                    throw new IndexOutOfBoundsException();
                }
                if (this.base64EncodedText == null) {
                    this.base64EncodedText = new char[this.base64AttData.length()];
                    this.base64AttData.writeTo(this.base64EncodedText, 0);
                }
                int n5 = Math.min(n4 - n, n3);
                System.arraycopy(this.base64EncodedText, n, cArray, n2, n5);
                return n5;
            }
            return this.reader.getTextCharacters(n, cArray, n2, n3);
        }

        @Override
        public String getText() {
            if (this.xopReferencePresent) {
                return this.base64AttData.toString();
            }
            return this.reader.getText();
        }

        protected boolean isXopReference() throws XMLStreamException {
            return this.xopReferencePresent;
        }

        protected String getXopHref() {
            return this.xopHref;
        }

        public MimeMultipartParser getMimeMultipartParser() {
            return this.mimeMP;
        }
    }
}

