/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.ApplicationLogger;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.iosrobovm.DefaultIOSInput;
import com.badlogic.gdx.backends.iosrobovm.IOSApplicationConfiguration;
import com.badlogic.gdx.backends.iosrobovm.IOSApplicationLogger;
import com.badlogic.gdx.backends.iosrobovm.IOSAudio;
import com.badlogic.gdx.backends.iosrobovm.IOSFiles;
import com.badlogic.gdx.backends.iosrobovm.IOSGraphics;
import com.badlogic.gdx.backends.iosrobovm.IOSInput;
import com.badlogic.gdx.backends.iosrobovm.IOSNet;
import com.badlogic.gdx.backends.iosrobovm.IOSPreferences;
import com.badlogic.gdx.backends.iosrobovm.IOSScreenBounds;
import com.badlogic.gdx.backends.iosrobovm.IOSUIViewController;
import com.badlogic.gdx.backends.iosrobovm.IOSViewControllerListener;
import com.badlogic.gdx.backends.iosrobovm.objectal.OALIOSAudio;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import java.io.File;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSProcessInfo;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.uikit.UIApplication;
import org.robovm.apple.uikit.UIApplicationDelegateAdapter;
import org.robovm.apple.uikit.UIApplicationLaunchOptions;
import org.robovm.apple.uikit.UIDevice;
import org.robovm.apple.uikit.UIPasteboard;
import org.robovm.apple.uikit.UIScreen;
import org.robovm.apple.uikit.UIUserInterfaceIdiom;
import org.robovm.apple.uikit.UIViewController;
import org.robovm.apple.uikit.UIWindow;
import org.robovm.rt.bro.Bro;

public class IOSApplication
implements Application {
    static final boolean IS_METALANGLE = false;
    UIApplication uiApp;
    UIWindow uiWindow;
    ApplicationListener listener;
    IOSViewControllerListener viewControllerListener;
    IOSApplicationConfiguration config;
    IOSGraphics graphics;
    IOSAudio audio;
    Files files;
    IOSInput input;
    IOSNet net;
    int logLevel = 3;
    ApplicationLogger applicationLogger;
    float pixelsPerPoint;
    private IOSScreenBounds lastScreenBounds = null;
    Array<Runnable> runnables = new Array();
    Array<Runnable> executedRunnables = new Array();
    Array<LifecycleListener> lifecycleListeners = new Array();

    public IOSApplication(ApplicationListener listener, IOSApplicationConfiguration config) {
        this.listener = listener;
        this.config = config;
    }

    final boolean didFinishLaunching(UIApplication uiApp, UIApplicationLaunchOptions options) {
        this.setApplicationLogger(new IOSApplicationLogger());
        Gdx.app = this;
        this.uiApp = uiApp;
        uiApp.setIdleTimerDisabled(this.config.preventScreenDimming);
        Gdx.app.debug("IOSApplication", "iOS version: " + UIDevice.getCurrentDevice().getSystemVersion());
        Gdx.app.debug("IOSApplication", "Running in " + (Bro.IS_64BIT ? "64-bit" : "32-bit") + " mode");
        this.pixelsPerPoint = (float)UIScreen.getMainScreen().getNativeScale();
        Gdx.app.debug("IOSApplication", "Pixels per point: " + this.pixelsPerPoint);
        this.uiWindow = new UIWindow(UIScreen.getMainScreen().getBounds());
        this.uiWindow.makeKeyAndVisible();
        uiApp.getDelegate().setWindow(this.uiWindow);
        this.input = this.createInput();
        this.graphics = this.createGraphics();
        Gdx.gl = Gdx.gl20 = this.graphics.gl20;
        Gdx.gl30 = this.graphics.gl30;
        this.files = this.createFiles();
        this.audio = this.createAudio(this.config);
        this.net = new IOSNet(this, this.config);
        Gdx.files = this.files;
        Gdx.graphics = this.graphics;
        Gdx.audio = this.audio;
        Gdx.input = this.input;
        Gdx.net = this.net;
        this.input.setupPeripherals();
        this.uiWindow.setRootViewController((UIViewController)this.graphics.viewController);
        this.graphics.updateSafeInsets();
        Gdx.app.debug("IOSApplication", "created");
        this.listener.create();
        this.listener.resize(this.graphics.getWidth(), this.graphics.getHeight());
        this.graphics.view.display();
        return true;
    }

    protected Files createFiles() {
        return new IOSFiles();
    }

    protected IOSAudio createAudio(IOSApplicationConfiguration config) {
        return new OALIOSAudio(config);
    }

    protected IOSGraphics createGraphics() {
        return new IOSGraphics(this, this.config, this.input, this.config.useGL30);
    }

    protected IOSUIViewController createUIViewController(IOSGraphics graphics) {
        return new IOSUIViewController(this, graphics);
    }

    protected IOSInput createInput() {
        return new DefaultIOSInput(this);
    }

    protected int guessUnknownPpi() {
        int ppi = UIDevice.getCurrentDevice().getUserInterfaceIdiom() == UIUserInterfaceIdiom.Pad ? 132 * (int)this.pixelsPerPoint : 164 * (int)this.pixelsPerPoint;
        this.error("IOSApplication", "Device PPI unknown. PPI value has been guessed to " + ppi + " but may be wrong");
        return ppi;
    }

    public UIViewController getUIViewController() {
        return this.graphics.viewController;
    }

    public UIWindow getUIWindow() {
        return this.uiWindow;
    }

    protected IOSScreenBounds computeBounds() {
        CGRect screenBounds = this.uiWindow.getBounds();
        CGRect statusBarFrame = this.uiApp.getStatusBarFrame();
        double statusBarHeight = statusBarFrame.getHeight();
        double screenWidth = screenBounds.getWidth();
        double screenHeight = screenBounds.getHeight();
        if (statusBarHeight != 0.0) {
            this.debug("IOSApplication", "Status bar is visible (height = " + statusBarHeight + ")");
            screenHeight -= statusBarHeight;
        } else {
            this.debug("IOSApplication", "Status bar is not visible");
        }
        boolean offsetX = false;
        int offsetY = (int)Math.round(statusBarHeight);
        int width = (int)Math.round(screenWidth);
        int height = (int)Math.round(screenHeight);
        int backBufferWidth = (int)Math.round(screenWidth * (double)this.pixelsPerPoint);
        int backBufferHeight = (int)Math.round(screenHeight * (double)this.pixelsPerPoint);
        this.debug("IOSApplication", "Computed bounds are x=0 y=" + offsetY + " w=" + width + " h=" + height + " bbW= " + backBufferWidth + " bbH= " + backBufferHeight);
        this.lastScreenBounds = new IOSScreenBounds(0, offsetY, width, height, backBufferWidth, backBufferHeight);
        return this.lastScreenBounds;
    }

    public IOSScreenBounds getScreenBounds() {
        if (this.lastScreenBounds == null) {
            return this.computeBounds();
        }
        return this.lastScreenBounds;
    }

    final void didBecomeActive(UIApplication uiApp) {
        Gdx.app.debug("IOSApplication", "resumed");
        this.audio.didBecomeActive();
        this.graphics.makeCurrent();
        this.graphics.resume();
    }

    final void willEnterForeground(UIApplication uiApp) {
        this.audio.willEnterForeground();
    }

    final void willResignActive(UIApplication uiApp) {
        Gdx.app.debug("IOSApplication", "paused");
        this.audio.willResignActive();
        this.graphics.makeCurrent();
        this.graphics.pause();
        Gdx.gl.glFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void willTerminate(UIApplication uiApp) {
        Array<LifecycleListener> listeners;
        Gdx.app.debug("IOSApplication", "disposed");
        this.audio.willTerminate();
        this.graphics.makeCurrent();
        Array<LifecycleListener> array = listeners = this.lifecycleListeners;
        synchronized (array) {
            for (LifecycleListener listener : listeners) {
                listener.pause();
            }
        }
        this.listener.dispose();
        Gdx.gl.glFinish();
    }

    @Override
    public ApplicationListener getApplicationListener() {
        return this.listener;
    }

    @Override
    public Graphics getGraphics() {
        return this.graphics;
    }

    @Override
    public Audio getAudio() {
        return this.audio;
    }

    @Override
    public Input getInput() {
        return this.input;
    }

    @Override
    public Files getFiles() {
        return this.files;
    }

    @Override
    public Net getNet() {
        return this.net;
    }

    @Override
    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(tag, message);
        }
    }

    @Override
    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(tag, message, exception);
        }
    }

    @Override
    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(tag, message);
        }
    }

    @Override
    public void log(String tag, String message, Throwable exception) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(tag, message, exception);
        }
    }

    @Override
    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(tag, message);
        }
    }

    @Override
    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(tag, message, exception);
        }
    }

    @Override
    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setApplicationLogger(ApplicationLogger applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    @Override
    public ApplicationLogger getApplicationLogger() {
        return this.applicationLogger;
    }

    @Override
    public Application.ApplicationType getType() {
        return Application.ApplicationType.iOS;
    }

    @Override
    public int getVersion() {
        return (int)NSProcessInfo.getSharedProcessInfo().getOperatingSystemVersion().getMajorVersion();
    }

    @Override
    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Override
    public long getNativeHeap() {
        return this.getJavaHeap();
    }

    @Override
    public Preferences getPreferences(String name) {
        File libraryPath = new File(System.getenv("HOME"), "Library");
        File finalPath = new File(libraryPath, name + ".plist");
        NSMutableDictionary nsDictionary = NSMutableDictionary.read((File)finalPath);
        if (nsDictionary == null) {
            nsDictionary = new NSMutableDictionary();
            nsDictionary.write(finalPath, false);
        }
        return new IOSPreferences((NSMutableDictionary<NSString, NSObject>)nsDictionary, finalPath.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add(runnable);
            Gdx.graphics.requestRendering();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRunnables() {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.executedRunnables.clear();
            this.executedRunnables.addAll(this.runnables);
            this.runnables.clear();
        }
        for (int i = 0; i < this.executedRunnables.size; ++i) {
            try {
                this.executedRunnables.get(i).run();
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public void exit() {
        System.exit(0);
    }

    @Override
    public Clipboard getClipboard() {
        return new Clipboard(){

            @Override
            public void setContents(String content) {
                UIPasteboard.getGeneralPasteboard().setString(content);
            }

            @Override
            public boolean hasContents() {
                return UIPasteboard.getGeneralPasteboard().hasStrings();
            }

            @Override
            public String getContents() {
                return UIPasteboard.getGeneralPasteboard().getString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.removeValue(listener, true);
        }
    }

    public void addViewControllerListener(IOSViewControllerListener listener) {
        this.viewControllerListener = listener;
    }

    public static abstract class Delegate
    extends UIApplicationDelegateAdapter {
        private IOSApplication app;

        protected abstract IOSApplication createApplication();

        public boolean didFinishLaunching(UIApplication application, UIApplicationLaunchOptions launchOptions) {
            application.addStrongRef((Object)this);
            this.app = this.createApplication();
            return this.app.didFinishLaunching(application, launchOptions);
        }

        public void didBecomeActive(UIApplication application) {
            this.app.didBecomeActive(application);
        }

        public void willEnterForeground(UIApplication application) {
            this.app.willEnterForeground(application);
        }

        public void willResignActive(UIApplication application) {
            this.app.willResignActive(application);
        }

        public void willTerminate(UIApplication application) {
            this.app.willTerminate(application);
        }
    }
}

