/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.AbstractController;
import com.badlogic.gdx.controllers.ControllerMapping;
import com.badlogic.gdx.controllers.ControllerPowerLevel;
import com.badlogic.gdx.controllers.MfiMapping;
import com.badlogic.gdx.utils.TimeUtils;
import java.util.UUID;
import org.robovm.apple.corehaptic.CHHapticEngine;
import org.robovm.apple.corehaptic.CHHapticEvent;
import org.robovm.apple.corehaptic.CHHapticEventParameter;
import org.robovm.apple.corehaptic.CHHapticEventParameterID;
import org.robovm.apple.corehaptic.CHHapticEventType;
import org.robovm.apple.corehaptic.CHHapticPattern;
import org.robovm.apple.corehaptic.CHHapticPatternPlayer;
import org.robovm.apple.foundation.Foundation;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.gamecontroller.GCController;
import org.robovm.apple.gamecontroller.GCControllerAxisInput;
import org.robovm.apple.gamecontroller.GCControllerButtonInput;
import org.robovm.apple.gamecontroller.GCControllerDirectionPad;
import org.robovm.apple.gamecontroller.GCControllerElement;
import org.robovm.apple.gamecontroller.GCControllerPlayerIndex;
import org.robovm.apple.gamecontroller.GCExtendedGamepad;
import org.robovm.apple.gamecontroller.GCGamepad;
import org.robovm.apple.gamecontroller.GCHapticsLocality;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;

public class IosController
extends AbstractController {
    public static final int BUTTON_BACK = 8;
    public static final int BUTTON_PAUSE = 9;
    public static final int BUTTON_LEFT_STICK = 10;
    public static final int BUTTON_RIGHT_STICK = 11;
    public static final int BUTTON_DPAD_UP = 12;
    public static final int BUTTON_DPAD_DOWN = 13;
    public static final int BUTTON_DPAD_LEFT = 14;
    public static final int BUTTON_DPAD_RIGHT = 15;
    private final GCController controller;
    private final String uuid;
    private final boolean[] pressedButtons;
    private final float[] axisValues;
    private long lastPausePressedMs = 0L;
    private CHHapticEngine hapticEngine;
    private CHHapticPatternPlayer playingHapticPattern;
    private long vibrationEndMs;

    public IosController(GCController controller) {
        this.controller = controller;
        this.uuid = UUID.randomUUID().toString();
        this.pressedButtons = new boolean[this.getMaxButtonIndex() + 1];
        this.axisValues = new float[this.getAxisCount()];
        controller.retain();
        if (Foundation.getMajorSystemVersion() < 13) {
            controller.setControllerPausedHandler((VoidBlock1)new VoidBlock1<GCController>(){

                public void invoke(GCController gcController) {
                    IosController.this.onPauseButtonPressed();
                }
            });
        }
        if (controller.getExtendedGamepad() != null) {
            controller.getExtendedGamepad().setValueChangedHandler((VoidBlock2)new VoidBlock2<GCExtendedGamepad, GCControllerElement>(){

                public void invoke(GCExtendedGamepad gcExtendedGamepad, GCControllerElement gcControllerElement) {
                    IosController.this.onControllerValueChanged(gcControllerElement);
                }
            });
        } else if (controller.getGamepad() != null) {
            controller.getGamepad().setValueChangedHandler((VoidBlock2)new VoidBlock2<GCGamepad, GCControllerElement>(){

                public void invoke(GCGamepad gcGamepad, GCControllerElement gcControllerElement) {
                    IosController.this.onControllerValueChanged(gcControllerElement);
                }
            });
        }
        if (Foundation.getMajorSystemVersion() >= 14) {
            try {
                if (controller.getHaptics() != null) {
                    this.hapticEngine = controller.getHaptics().createEngine(GCHapticsLocality.Default);
                    this.hapticEngine.retain();
                }
            }
            catch (Throwable t) {
                Gdx.app.error("Controllers", "Failed to create haptics engine", t);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.controller.setControllerPausedHandler(null);
        if (this.controller.getExtendedGamepad() != null) {
            this.controller.getExtendedGamepad().setValueChangedHandler(null);
        } else if (this.controller.getGamepad() != null) {
            this.controller.getGamepad().setValueChangedHandler(null);
        }
        this.controller.release();
        if (this.hapticEngine != null) {
            this.hapticEngine.release();
        }
    }

    protected void onPauseButtonPressed() {
        this.lastPausePressedMs = TimeUtils.millis();
        this.notifyListenersButtonDown(9);
        this.notifyListenersButtonUp(9);
    }

    protected void onControllerValueChanged(GCControllerElement gcControllerElement) {
        if (gcControllerElement instanceof GCControllerButtonInput) {
            GCControllerButtonInput buttonElement = (GCControllerButtonInput)gcControllerElement;
            boolean pressed = buttonElement.isPressed();
            int buttonNum = this.getConstFromButtonInput(buttonElement);
            if (buttonNum >= 0 && this.pressedButtons[buttonNum] != pressed) {
                this.pressedButtons[buttonNum] = pressed;
                if (pressed) {
                    this.notifyListenersButtonDown(buttonNum);
                } else {
                    this.notifyListenersButtonUp(buttonNum);
                }
            }
        } else if (gcControllerElement instanceof GCControllerDirectionPad) {
            for (int buttonNum = 12; buttonNum <= 15; ++buttonNum) {
                GCControllerButtonInput dpadButton = this.getButtonFromConst(buttonNum);
                if (dpadButton == null || this.pressedButtons[buttonNum] == dpadButton.isPressed()) continue;
                this.pressedButtons[buttonNum] = dpadButton.isPressed();
                if (this.pressedButtons[buttonNum]) {
                    this.notifyListenersButtonDown(buttonNum);
                    continue;
                }
                this.notifyListenersButtonUp(buttonNum);
            }
            for (int axisIdx = 0; axisIdx < this.axisValues.length; ++axisIdx) {
                float axisValue = this.getAxis(axisIdx);
                if (axisValue == this.axisValues[axisIdx]) continue;
                this.axisValues[axisIdx] = axisValue;
                this.notifyListenersAxisMoved(axisIdx, axisValue);
            }
        }
    }

    protected int getConstFromButtonInput(GCControllerButtonInput controllerButtonInput) {
        int maxButtonNum = this.getMaxButtonIndex();
        for (int i = 0; i < maxButtonNum; ++i) {
            GCControllerButtonInput buttonFromConst = this.getButtonFromConst(i);
            if (buttonFromConst == null || controllerButtonInput != buttonFromConst) continue;
            return i;
        }
        if (controllerButtonInput != null) {
            Gdx.app.log("Controllers", "Pressed unknown button: " + controllerButtonInput.toString());
        }
        return -1;
    }

    protected GCControllerButtonInput getButtonFromConst(int i) {
        switch (i) {
            case 0: {
                if (this.controller.getExtendedGamepad() != null) {
                    return this.controller.getExtendedGamepad().getButtonA();
                }
                return this.controller.getGamepad().getButtonA();
            }
            case 1: {
                if (this.controller.getExtendedGamepad() != null) {
                    return this.controller.getExtendedGamepad().getButtonB();
                }
                return this.controller.getGamepad().getButtonB();
            }
            case 2: {
                if (this.controller.getExtendedGamepad() != null) {
                    return this.controller.getExtendedGamepad().getButtonX();
                }
                return this.controller.getGamepad().getButtonX();
            }
            case 3: {
                if (this.controller.getExtendedGamepad() != null) {
                    return this.controller.getExtendedGamepad().getButtonY();
                }
                return this.controller.getGamepad().getButtonY();
            }
            case 4: {
                if (this.controller.getExtendedGamepad() != null) {
                    return this.controller.getExtendedGamepad().getLeftShoulder();
                }
                return this.controller.getGamepad().getLeftShoulder();
            }
            case 5: {
                if (this.controller.getExtendedGamepad() != null) {
                    return this.controller.getExtendedGamepad().getRightShoulder();
                }
                return this.controller.getGamepad().getRightShoulder();
            }
            case 6: {
                if (this.controller.getExtendedGamepad() == null) break;
                return this.controller.getExtendedGamepad().getLeftTrigger();
            }
            case 7: {
                if (this.controller.getExtendedGamepad() == null) break;
                return this.controller.getExtendedGamepad().getRightTrigger();
            }
            case 8: {
                if (Foundation.getMajorSystemVersion() < 13 || this.controller.getExtendedGamepad() == null) break;
                return this.controller.getExtendedGamepad().getButtonOptions();
            }
            case 9: {
                if (Foundation.getMajorSystemVersion() < 13 || this.controller.getExtendedGamepad() == null) break;
                return this.controller.getExtendedGamepad().getButtonMenu();
            }
            case 10: {
                if (Foundation.getMajorSystemVersion() < 13 || this.controller.getExtendedGamepad() == null) break;
                return this.controller.getExtendedGamepad().getLeftThumbstickButton();
            }
            case 11: {
                if (Foundation.getMajorSystemVersion() < 13 || this.controller.getExtendedGamepad() == null) break;
                return this.controller.getExtendedGamepad().getRightThumbstickButton();
            }
            case 12: {
                if (this.controller.getExtendedGamepad() != null) {
                    return this.controller.getExtendedGamepad().getDpad().getUp();
                }
                return this.controller.getGamepad().getDpad().getUp();
            }
            case 13: {
                if (this.controller.getExtendedGamepad() != null) {
                    return this.controller.getExtendedGamepad().getDpad().getDown();
                }
                return this.controller.getGamepad().getDpad().getDown();
            }
            case 14: {
                if (this.controller.getExtendedGamepad() != null) {
                    return this.controller.getExtendedGamepad().getDpad().getLeft();
                }
                return this.controller.getGamepad().getDpad().getLeft();
            }
            case 15: {
                if (this.controller.getExtendedGamepad() != null) {
                    return this.controller.getExtendedGamepad().getDpad().getRight();
                }
                return this.controller.getGamepad().getDpad().getRight();
            }
        }
        return null;
    }

    @Override
    public int getMinButtonIndex() {
        return 0;
    }

    @Override
    public int getMaxButtonIndex() {
        return Math.max(15, 9);
    }

    @Override
    public boolean getButton(int i) {
        GCControllerButtonInput buttonFromConst = this.getButtonFromConst(i);
        if (i == 9 && buttonFromConst == null) {
            if (this.lastPausePressedMs > 0L && TimeUtils.millis() - this.lastPausePressedMs <= 250L) {
                this.lastPausePressedMs = 0L;
                return true;
            }
            return false;
        }
        if (buttonFromConst != null) {
            return buttonFromConst.isPressed();
        }
        return false;
    }

    protected GCControllerAxisInput getAxisFromConst(int i) {
        switch (i) {
            case 0: {
                if (this.controller.getExtendedGamepad() == null) break;
                return this.controller.getExtendedGamepad().getLeftThumbstick().getXAxis();
            }
            case 1: {
                if (this.controller.getExtendedGamepad() == null) break;
                return this.controller.getExtendedGamepad().getLeftThumbstick().getYAxis();
            }
            case 2: {
                if (this.controller.getExtendedGamepad() == null) break;
                return this.controller.getExtendedGamepad().getRightThumbstick().getXAxis();
            }
            case 3: {
                if (this.controller.getExtendedGamepad() == null) break;
                return this.controller.getExtendedGamepad().getRightThumbstick().getYAxis();
            }
        }
        return null;
    }

    @Override
    public float getAxis(int i) {
        boolean isVertical;
        GCControllerAxisInput axisFromConst = this.getAxisFromConst(i);
        boolean bl = isVertical = i % 2 == 1;
        if (axisFromConst != null) {
            return axisFromConst.getValue() * (float)(isVertical ? -1 : 1);
        }
        return 0.0f;
    }

    @Override
    public String getName() {
        return this.controller.getVendorName();
    }

    @Override
    public String getUniqueId() {
        return this.uuid;
    }

    @Override
    public boolean supportsPlayerIndex() {
        return true;
    }

    @Override
    public int getPlayerIndex() {
        GCControllerPlayerIndex playerIndex = this.controller.getPlayerIndex();
        return playerIndex != null ? (int)playerIndex.value() : -1;
    }

    @Override
    public void setPlayerIndex(int index) {
        this.controller.setPlayerIndex(GCControllerPlayerIndex.valueOf((long)index));
    }

    @Override
    public int getAxisCount() {
        return this.controller.getExtendedGamepad() != null ? 4 : 0;
    }

    @Override
    public boolean canVibrate() {
        return this.hapticEngine != null;
    }

    @Override
    public void startVibration(int duration, float strength) {
        if (this.canVibrate()) {
            try {
                this.hapticEngine.start(null);
                this.playingHapticPattern = this.hapticEngine.createPlayer(this.constructRumbleEvent((float)duration / 1000.0f, strength));
                this.playingHapticPattern.start(0.0, null);
                this.vibrationEndMs = TimeUtils.millis() + (long)duration;
            }
            catch (Throwable t) {
                Gdx.app.error("Controllers", "Vibration failed", t);
            }
        }
    }

    @Override
    public boolean isVibrating() {
        return this.canVibrate() && TimeUtils.millis() < this.vibrationEndMs && this.playingHapticPattern != null;
    }

    @Override
    public void cancelVibration() {
        if (this.isVibrating()) {
            this.playingHapticPattern.cancelAndReturnError(null);
            this.playingHapticPattern = null;
            this.vibrationEndMs = 0L;
        }
    }

    @Override
    public ControllerMapping getMapping() {
        return MfiMapping.getInstance();
    }

    @Override
    public ControllerPowerLevel getPowerLevel() {
        if (Foundation.getMajorSystemVersion() >= 14) {
            switch (this.controller.getBattery().getBatteryState()) {
                case Discharging: {
                    float batteryLevel = this.controller.getBattery().getBatteryLevel();
                    if (batteryLevel <= 0.05f) {
                        return ControllerPowerLevel.POWER_EMPTY;
                    }
                    if (batteryLevel <= 0.2f) {
                        return ControllerPowerLevel.POWER_LOW;
                    }
                    if (batteryLevel <= 0.7f) {
                        return ControllerPowerLevel.POWER_MEDIUM;
                    }
                    return ControllerPowerLevel.POWER_FULL;
                }
                case Charging: {
                    return ControllerPowerLevel.POWER_WIRED;
                }
                case Full: {
                    return ControllerPowerLevel.POWER_FULL;
                }
            }
            return ControllerPowerLevel.POWER_UNKNOWN;
        }
        return ControllerPowerLevel.POWER_UNKNOWN;
    }

    public boolean equals(Object o) {
        return o instanceof IosController && ((IosController)o).getController() == this.controller;
    }

    public GCController getController() {
        return this.controller;
    }

    public CHHapticPattern constructRumbleEvent(float length, float strength) throws NSErrorException {
        NSArray params = new NSArray((NSObject[])new CHHapticEventParameter[]{new CHHapticEventParameter(CHHapticEventParameterID.HapticIntensity, strength), new CHHapticEventParameter(CHHapticEventParameterID.HapticSharpness, 0.5f)});
        return new CHHapticPattern(new NSArray((NSObject[])new CHHapticEvent[]{new CHHapticEvent(CHHapticEventType.HapticContinuous, params, 0.0, (double)length)}), new NSArray());
    }
}

